{*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2016 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}

{extends file="helpers/form/form.tpl"}

{block name="script"}
$(document).ready(function(){
$('#menuOrderUp').click(function(e){
	e.preventDefault();
    move(true);
});
$('#menuOrderDown').click(function(e){
    e.preventDefault();
    move();
});
$("#items").closest('form').on('submit', function(e) {
	$("#items option").prop('selected', true);
	serialize();
});
$("#addItem").click(add);
$("#availableItems").dblclick(add);
$("#removeItem").click(remove);
$("#items").dblclick(remove);
$("#items ").click(function(){
	var index_opt = $("#items option:selected").index();
    var number_cols = $('#number_cols_'+index_opt);
    if (number_cols.length)
	{
        number_cols.focus();
	}
});

function add()
{
	$("#availableItems option:selected").each(function(i){
		var val = $(this).val();
		var text = $(this).text();
		text = text.replace(/(^\s*)|(\s*$)/gi,"");
		if (val == "PRODUCT")
		{
			val = prompt('{l s='Indicate the ID number for the product' mod='tmverticalmenu' js=1}');
			if (val == null || val == "" || isNaN(val))
				return;
			text = '{l s='Product ID #' mod='tmverticalmenu' js=1}'+val;
			val = "PRD"+val;
		}
		var  index_opt = $("#items option").length;
		$("#items").append('<option value="'+val+'" selected="selected">'+text+'</option>');
		$('#number_cols_megamenu').append('<select class="number_cols_tmmegamenu" name="number_cols_'+index_opt+'" id="number_cols_'+index_opt+'">'+number_cols()+'</select>');
	});
	serialize();
	return false;
}

function number_cols()
{
    var j;
    var html = '';
    for(j=1; j<=12; j++)
    {
        html += '<option value="'+j+'">'+j+'</option>';
    }
    return html;
}

function remove()
{
	$("#items option:selected").each(function(i){
		$('#number_cols_'+i).remove();
		$(this).remove();
	});
	serialize();
	return false;
}

function serialize()
{
	var options = "";
	$("#items option").each(function(i){
		options += $(this).val()+",";
	});
	var menu_length = $("#items option").length;
	if(menu_length)
	{
        var $number_cols_menu = $('#number_cols_menu'), _value_cols = '';
        var tomove = $('#items option:selected');
        $('.number_cols_tmmegamenu').each(function(j){
			$(this).attr('id','number_cols_'+j).attr('name','number_cols_'+j);
			var _val_cols = $(this).val();
                _val_cols = _val_cols == '' ? 'no_number_cols': _val_cols;
            _value_cols +=','+$(this).val();
		});

        $number_cols_menu.val(_value_cols.substr(1));
        {*$('#number_cols_'+tomove.index()).focus();*}
	}

	$("#itemsInput").val(options.substr(0, options.length - 1));
}

$( document ).on( "click", "#number_cols_megamenu .number_cols_tmmegamenu",function(){
	$("#items option").prop('selected', false);
	$("#items option").eq($(this).index()).prop('selected', true);
	 serialize();
});

function move(up)
{
        var tomove = $('#items option:selected');
        if (tomove.length >1)
        {
                alert('{l s='Please select just one item' mod='tmverticalmenu'}');
                return false;
        }
		var number_cols = $('#number_cols_megamenu #number_cols_'+tomove.index());
        if (up){
                tomove.prev().insertAfter(tomove);
                number_cols.prev().insertAfter(number_cols).focus();
        } else {
                tomove.next().insertBefore(tomove);
                number_cols.next().insertBefore(number_cols).focus();
        }
        serialize();
        return false;
}
});
{/block}

{block name="input"}
    {if $input.type == 'link_choice'}
	    <div class="row">
	    	<div class="col-lg-1">
	    		<h4 style="margin-top:5px;">{l s='Change position' mod='tmverticalmenu'}</h4> 
                <a href="#" id="menuOrderUp" class="btn btn-default" style="font-size:20px;display:block;"><i class="icon-chevron-up"></i></a><br/>
                <a href="#" id="menuOrderDown" class="btn btn-default" style="font-size:20px;display:block;"><i class="icon-chevron-down"></i></a><br/>
	    	</div>
	    	<div class="col-lg-4">
	    		<h4 style="margin-top:5px;">{l s='Selected items' mod='tmverticalmenu'}</h4>
	    		{$selected_links}
	    	</div>
	    	<div class="col-lg-4">
	    		<h4 style="margin-top:5px;">{l s='Available items' mod='tmverticalmenu'}</h4>
	    		{$choices}
	    	</div>
	    	
	    </div>
	    <br/>
	    <div class="row">
	    	<div class="col-lg-1"></div>
	    	<div class="col-lg-4"><a href="#" id="removeItem" class="btn btn-default"><i class="icon-arrow-right"></i> {l s='Remove' mod='tmverticalmenu'}</a></div>
	    	<div class="col-lg-4"><a href="#" id="addItem" class="btn btn-default"><i class="icon-arrow-left"></i> {l s='Add' mod='tmverticalmenu'}</a></div>
	    </div>
		<br/>
	    <div class="row">
            <div class="col-lg-1"></div>
            <div class="col-lg-4">
                <h4 style="margin-top:5px;">{l s='Columns Number' mod='tmverticalmenu'}</h4>
				{$MOD_TMVERTICALMENU_COLS}
                <input type="hidden" value="" name="number_cols_menu" id="number_cols_menu">
            </div>
	    </div>
	{else}
		{$smarty.block.parent}
    {/if}
{/block}
